<?php
require_once __DIR__ . '/init.php';

if (current_user()) redirect('index.php');

$error = null;

if (is_post()) {
    if (!csrf_validate($_POST['csrf_token'] ?? null)) {
        $error = 'Güvenlik doğrulaması başarısız.';
    } else {
        $ok = auth_login((string)($_POST['email'] ?? ''), (string)($_POST['password'] ?? ''));
        if ($ok) redirect('index.php');
        $error = 'E-posta veya şifre hatalı.';
    }
}
?>
<!doctype html>
<html lang="tr">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Panel Giriş</title>
  <link rel="stylesheet" href="panel.css">
</head>
<body>

  <div class="auth-wrap">
    <div class="auth-card">

      <div class="auth-header">
        <h1 class="auth-title">Panele Giriş</h1>
        <p class="auth-subtitle">Bungalov ilanlarını yönetmek için giriş yap.</p>
      </div>

      <?php if ($error): ?>
        <div class="alert alert-error"><?= e($error) ?></div>
      <?php endif; ?>

      <form class="auth-form" method="post" autocomplete="on">
        <input type="hidden" name="csrf_token" value="<?= e(csrf_token()) ?>">

        <div class="field">
          <div class="label">E-posta</div>
          <input class="input" type="email" name="email" placeholder="ornek@mail.com" required>
        </div>

        <div class="field">
          <div class="label">Şifre</div>
          <input class="input" type="password" name="password" placeholder="••••••••" required>
          <div class="help">
            Şifreni unuttuysan yakında “Şifremi Unuttum” eklenecek.
          </div>
        </div>

        <div class="actions">
          <button class="btn btn-primary" type="submit">Giriş Yap</button>
          <a class="btn btn-ghost" href="kayit-ol.php">Kayıt Ol</a>
        </div>

        <div class="divider"></div>
        <div class="small center">© <?= date('Y') ?> Bungalov Sepeti</div>
      </form>

    </div>
  </div>

</body>
</html>
