// /home/bungalowsepeti/public_html/panel/js/toast.js
(() => {
  "use strict";

  window.BS = window.BS || {};
  const BS = window.BS;

  const STYLE_ID = "bs-toast-style-v1";
  const CONTAINER_CLASS = "toast-container";
  const DEFAULT_MS = 8000;

  const ensureStyle = () => {
    if (document.getElementById(STYLE_ID)) return;

    const css = `
.${CONTAINER_CLASS}{position:fixed;right:18px;bottom:18px;z-index:99999;display:flex;flex-direction:column;gap:10px;align-items:flex-end;pointer-events:none;max-width:min(360px,calc(100vw - 36px));}
.toast{pointer-events:auto;min-width:240px;max-width:100%;background:#fff;border:1px solid rgba(11,22,53,.14);border-radius:12px;box-shadow:0 18px 50px rgba(0,0,0,.18);padding:12px 12px;display:flex;gap:10px;align-items:flex-start;opacity:0;transform:translateY(8px);transition:opacity .18s ease,transform .18s ease;}
.toast-in{opacity:1;transform:translateY(0);}
.toast-out{opacity:0;transform:translateY(8px);}
.toast-msg{flex:1;color:#0b1635;font-size:13px;line-height:1.45;white-space:pre-wrap;}
.toast-x{border:0;background:transparent;cursor:pointer;line-height:1;padding:4px 6px;font-size:16px;color:rgba(11,22,53,.60);}
.toast-x:hover{color:#0b1635;}
.toast-info{border-color:rgba(0,194,255,.35);}
.toast-success{border-color:rgba(47,227,159,.40);}
.toast-warning{border-color:rgba(255,184,0,.42);}
.toast-error{border-color:rgba(255,77,109,.40);}
    `.trim();

    const style = document.createElement("style");
    style.id = STYLE_ID;
    style.type = "text/css";
    style.appendChild(document.createTextNode(css));
    document.head.appendChild(style);
  };

  const ensureContainer = () => {
    ensureStyle();

    let c = document.querySelector("." + CONTAINER_CLASS);
    if (!c) {
      c = document.createElement("div");
      c.className = CONTAINER_CLASS;
      c.setAttribute("aria-live", "polite");
      c.setAttribute("aria-atomic", "true");
      document.body.appendChild(c);
    }
    return c;
  };

  const normType = (t) => {
    const v = String(t || "").trim().toLowerCase();
    if (v === "success") return "success";
    if (v === "warning" || v === "warn") return "warning";
    if (v === "danger") return "error";
    if (v === "error" || v === "err") return "error";
    return "info";
  };

  const createToast = (msg, type, timeout) => {
    const container = ensureContainer();
    const t = normType(type);

    const msRaw = Number(timeout);
    const ms = Number.isFinite(msRaw) ? Math.max(800, msRaw) : DEFAULT_MS;

    const el = document.createElement("div");
    el.className = "toast toast-" + t;

    const msgEl = document.createElement("div");
    msgEl.className = "toast-msg";
    msgEl.textContent = String(msg || "");

    const xBtn = document.createElement("button");
    xBtn.className = "toast-x";
    xBtn.type = "button";
    xBtn.setAttribute("aria-label", "Kapat");
    xBtn.textContent = "✕";

    el.appendChild(msgEl);
    el.appendChild(xBtn);
    container.appendChild(el);

    let removed = false;
    let timer = 0;
    let startedAt = Date.now();
    let remaining = ms;

    const remove = () => {
      if (removed) return;
      removed = true;
      clearTimeout(timer);
      el.classList.add("toast-out");
      setTimeout(() => { if (el && el.parentNode) el.remove(); }, 200);
    };

    const arm = () => {
      clearTimeout(timer);
      startedAt = Date.now();
      timer = window.setTimeout(remove, remaining);
    };

    xBtn.addEventListener("click", remove);

    // hover -> pause
    el.addEventListener("mouseenter", () => {
      if (removed) return;
      const passed = Date.now() - startedAt;
      remaining = Math.max(0, remaining - passed);
      clearTimeout(timer);
    });

    el.addEventListener("mouseleave", () => {
      if (removed) return;
      if (remaining <= 0) { remove(); return; }
      arm();
    });

    requestAnimationFrame(() => el.classList.add("toast-in"));
    arm();

    return el;
  };

  BS.toast = (msg, type = "info", timeout = DEFAULT_MS) => createToast(msg, type, timeout);

  BS.toastSuccess = (msg, timeout = DEFAULT_MS) => createToast(msg, "success", timeout);
  BS.toastError = (msg, timeout = DEFAULT_MS) => createToast(msg, "error", timeout);
  BS.toastWarning = (msg, timeout = DEFAULT_MS) => createToast(msg, "warning", timeout);
})();
