<?php
require_once __DIR__ . '/init.php';

if (current_user()) redirect('index.php');

$error = null;
$success = null;

$values = [
    'tesis_ismi' => '',
    'email' => '',
];

if (is_post()) {
    if (!csrf_validate($_POST['csrf_token'] ?? null)) {
        $error = 'Güvenlik doğrulaması başarısız.';
    } else {
        $tesis_ismi = trim((string)($_POST['tesis_ismi'] ?? ''));
        $email = trim(mb_strtolower((string)($_POST['email'] ?? '')));
        $password = (string)($_POST['password'] ?? '');
        $password2 = (string)($_POST['password2'] ?? '');
        $owner_ok = (string)($_POST['owner_ok'] ?? '') === '1';

        $values['tesis_ismi'] = $tesis_ismi;
        $values['email'] = $email;

        if ($tesis_ismi === '' || $email === '' || $password === '' || $password2 === '') {
            $error = 'Lütfen tüm alanları doldurun.';
        } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
            $error = 'E-posta formatı hatalı.';
        } elseif (mb_strlen($password) < 6) {
            $error = 'Şifre en az 6 karakter olmalı.';
        } elseif ($password !== $password2) {
            $error = 'Şifreler eşleşmiyor.';
        } elseif (!$owner_ok) {
            $error = 'Devam etmek için onay kutusunu işaretleyin.';
        } else {
            $hashAlgo = defined('PASSWORD_ARGON2I') ? PASSWORD_ARGON2I : PASSWORD_DEFAULT;
            $hash = password_hash($password, $hashAlgo);

            $verification_code = str_pad((string)random_int(0, 999999), 6, '0', STR_PAD_LEFT);
            $verification_code_expiry = time() + 30 * 60;

            try {
                $stmt = db()->prepare("
                    INSERT INTO tesisler
                        (rol, tesis_ismi, email, password, belge_onay, kredi_puani, gorev_kutusu_gosterme, is_verified, verification_code, verification_code_expiry)
                    VALUES
                        ('kullanici', :tesis_ismi, :email, :password, 'bos', 0, 1, 0, :verification_code, :verification_code_expiry)
                ");
                $stmt->execute([
                    ':tesis_ismi' => $tesis_ismi,
                    ':email' => $email,
                    ':password' => $hash,
                    ':verification_code' => $verification_code,
                    ':verification_code_expiry' => $verification_code_expiry,
                ]);

                $success = 'Kayıt başarılı. Giriş sayfasına yönlendirilebilirsin.';
                $values = ['tesis_ismi' => '', 'email' => ''];
            } catch (PDOException $e) {
                if (($e->errorInfo[0] ?? '') === '23000') $error = 'Bu e-posta ile kayıt zaten var.';
                else $error = 'Kayıt sırasında hata oluştu.';
            }
        }
    }
}
?>
<!doctype html>
<html lang="tr">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Kayıt Ol</title>
  <link rel="stylesheet" href="panel.css">
</head>
<body>

  <div class="auth-wrap">
    <div class="auth-card">

      <div class="auth-header">
        <h1 class="auth-title">Tesis Kaydı Oluştur</h1>
        <p class="auth-subtitle">Sadece bungalov/villa işletme sahipleri kayıt olabilir.</p>
      </div>

      <?php if ($error): ?>
        <div class="alert alert-error"><?= e($error) ?></div>
      <?php endif; ?>

      <?php if ($success): ?>
        <div class="alert alert-success">
          <?= e($success) ?> <a class="link" href="giris.php">Giriş Yap</a>
        </div>
      <?php endif; ?>

      <form class="auth-form" method="post" autocomplete="on">
        <input type="hidden" name="csrf_token" value="<?= e(csrf_token()) ?>">

        <div class="field">
          <div class="label">Tesis İsmi</div>
          <input class="input" type="text" name="tesis_ismi" placeholder="Örn: Güneş Bungalov" required value="<?= e($values['tesis_ismi']) ?>">
        </div>

        <div class="field">
          <div class="label">E-posta</div>
          <input class="input" type="email" name="email" placeholder="ornek@mail.com" required value="<?= e($values['email']) ?>">
        </div>

        <div class="field">
          <div class="label">Şifre</div>
          <input class="input" type="password" name="password" placeholder="En az 6 karakter" required>
        </div>

        <div class="field">
          <div class="label">Şifre (Tekrar)</div>
          <input class="input" type="password" name="password2" placeholder="Şifreyi tekrar yaz" required>
        </div>

        <div class="checkbox-row">
          <input class="checkbox" type="checkbox" name="owner_ok" value="1" required>
          <div class="checkbox-text">
            Bungalov/villa işletme sahibiyim ve bilgilerin doğrulanmasını kabul ediyorum.
          </div>
        </div>

        <div class="actions">
          <button class="btn btn-primary" type="submit">Kayıt Ol</button>
          <a class="btn btn-ghost" href="giris.php">Zaten hesabım var</a>
        </div>

        <div class="divider"></div>
        <div class="small center">© <?= date('Y') ?> Bungalov Sepeti</div>
      </form>

    </div>
  </div>

</body>
</html>
