<?php
// /home/bungalowsepeti/public_html/panel/hesap-yonetimi.php
require_once __DIR__ . '/init.php';

require_login();
auth_refresh_user();

$u = current_user();
$tesisId = (int)($u['id'] ?? 0);

function clean_text(string $s, int $maxLen): string {
  $s = preg_replace('~[\x00-\x1F\x7F]~u', '', $s);
  $s = trim($s);
  if ($maxLen > 0) $s = mb_substr($s, 0, $maxLen);
  return $s;
}

function clean_phone(string $s, int $maxLen = 20): string {
  $d = preg_replace('~\D+~', '', (string)$s);
  $d = trim($d);
  if ($d === '') return '';
  if (strlen($d) > $maxLen) $d = substr($d, 0, $maxLen);
  return $d;
}

function clean_email_nullable(string $s, int $maxLen = 100): string {
  $s = clean_text($s, $maxLen);
  if ($s === '') return '';
  return filter_var($s, FILTER_VALIDATE_EMAIL) ? $s : '';
}

function clean_time_hhmm(string $s): string {
  $s = trim((string)$s);
  if ($s === '') return '';
  if (!preg_match('~^\d{1,2}:\d{2}$~', $s)) return '';
  [$h,$m] = explode(':', $s, 2);
  $h = (int)$h; $m = (int)$m;
  if ($h < 0 || $h > 23 || $m < 0 || $m > 59) return '';
  return str_pad((string)$h, 2, '0', STR_PAD_LEFT) . ':' . str_pad((string)$m, 2, '0', STR_PAD_LEFT);
}

$iller = [
  'Adana','Adıyaman','Afyonkarahisar','Ağrı','Amasya','Ankara','Antalya','Artvin','Aydın','Balıkesir','Bilecik','Bingöl','Bitlis','Bolu','Burdur','Bursa',
  'Çanakkale','Çankırı','Çorum','Denizli','Diyarbakır','Edirne','Elazığ','Erzincan','Erzurum','Eskişehir','Gaziantep','Giresun','Gümüşhane','Hakkari','Hatay',
  'Isparta','Mersin','İstanbul','İzmir','Kars','Kastamonu','Kayseri','Kırklareli','Kırşehir','Kocaeli','Konya','Kütahya','Malatya','Manisa','Kahramanmaraş',
  'Mardin','Muğla','Muş','Nevşehir','Niğde','Ordu','Rize','Sakarya','Samsun','Siirt','Sinop','Sivas','Tekirdağ','Tokat','Trabzon','Tunceli','Şanlıurfa','Uşak',
  'Van','Yozgat','Zonguldak','Aksaray','Bayburt','Karaman','Kırıkkale','Batman','Şırnak','Bartın','Ardahan','Iğdır','Yalova','Karabük','Kilis','Osmaniye','Düzce'
];

$ilcelerMap = [
  'İstanbul' => [
    'Adalar','Arnavutköy','Ataşehir','Avcılar','Bağcılar','Bahçelievler','Bakırköy','Başakşehir','Bayrampaşa','Beşiktaş','Beykoz','Beylikdüzü','Beyoğlu',
    'Büyükçekmece','Çatalca','Çekmeköy','Esenler','Esenyurt','Eyüpsultan','Fatih','Gaziosmanpaşa','Güngören','Kadıköy','Kağıthane','Kartal','Küçükçekmece',
    'Maltepe','Pendik','Sancaktepe','Sarıyer','Silivri','Sultanbeyli','Sultangazi','Şile','Şişli','Tuzla','Ümraniye','Üsküdar','Zeytinburnu'
  ],
  'Ankara' => ['Akyurt','Altındağ','Ayaş','Bala','Beypazarı','Çamlıdere','Çankaya','Çubuk','Elmadağ','Etimesgut','Evren','Gölbaşı','Güdül','Haymana','Kahramankazan','Kalecik','Keçiören','Kızılcahamam','Mamak','Nallıhan','Polatlı','Pursaklar','Sincan','Şereflikoçhisar','Yenimahalle'],
  'İzmir' => ['Aliağa','Balçova','Bayındır','Bayraklı','Bergama','Beydağ','Bornova','Buca','Çeşme','Çiğli','Dikili','Foça','Gaziemir','Güzelbahçe','Karabağlar','Karaburun','Karşıyaka','Kemalpaşa','Kınık','Kiraz','Konak','Menderes','Menemen','Narlıdere','Ödemiş','Seferihisar','Selçuk','Tire','Torbalı','Urla']
];

$error = null;
$okMsg = null;

$st = db()->prepare("SELECT * FROM tesisler WHERE id = :t LIMIT 1");
$st->execute([':t' => $tesisId]);
$row = $st->fetch();
if (!$row) { http_response_code(404); echo "Kayıt bulunamadı."; exit; }

$val = [
  'tesis_ismi' => (string)($row['tesis_ismi'] ?? ''),
  'email' => (string)($row['email'] ?? ''),
  'yetkili_isim' => (string)($row['yetkili_isim'] ?? ''),
  'yetkili_soyisim' => (string)($row['yetkili_soyisim'] ?? ''),
  'cep_telefonu' => (string)($row['cep_telefonu'] ?? ''),
  'whatsapp_no' => (string)($row['whatsapp_no'] ?? ''),
  'tesis_adresi' => (string)($row['tesis_adresi'] ?? ''),
  'tesis_il' => (string)($row['tesis_il'] ?? ''),
  'tesis_ilce' => (string)($row['tesis_ilce'] ?? ''),
  'sezon' => (string)($row['sezon'] ?? ''),
  'giris_saati' => (string)($row['giris_saati'] ?? ''),
  'cikis_saati' => (string)($row['cikis_saati'] ?? ''),
  'firma_unvani' => (string)($row['firma_unvani'] ?? ''),
  'fatura_adresi' => (string)($row['fatura_adresi'] ?? ''),
  'fatura_il' => (string)($row['fatura_il'] ?? ''),
  'fatura_ilce' => (string)($row['fatura_ilce'] ?? ''),
  'vergi_dairesi' => (string)($row['vergi_dairesi'] ?? ''),
  'vergi_no' => (string)($row['vergi_no'] ?? ''),
  'fatura_mail' => (string)($row['fatura_mail'] ?? ''),
  'kep_adresi' => (string)($row['kep_adresi'] ?? ''),
  'mersis_no' => (string)($row['mersis_no'] ?? ''),
];

if (is_post()) {
  if (!csrf_validate($_POST['csrf_token'] ?? null)) {
    $error = 'Güvenlik doğrulaması başarısız.';
  } else {
    $section = (string)($_POST['section'] ?? '');

    if ($section === 'tesis') {
      $yetkili_isim = clean_text((string)($_POST['yetkili_isim'] ?? ''), 100);
      $yetkili_soyisim = clean_text((string)($_POST['yetkili_soyisim'] ?? ''), 100);
      $cep = clean_phone((string)($_POST['cep_telefonu'] ?? ''), 20);
      $wa = clean_phone((string)($_POST['whatsapp_no'] ?? ''), 20);

      $sezon = clean_text((string)($_POST['sezon'] ?? ''), 10);
      $allowedSezon = ['Yaz','Kış','Yaz/Kış',''];
      if (!in_array($sezon, $allowedSezon, true)) $sezon = '';

      $giris = clean_time_hhmm((string)($_POST['giris_saati'] ?? ''));
      $cikis = clean_time_hhmm((string)($_POST['cikis_saati'] ?? ''));

      if (!$error && $yetkili_isim === '') $error = 'Yetkili isim zorunlu.';
      if (!$error && $yetkili_soyisim === '') $error = 'Yetkili soyisim zorunlu.';
      if (!$error && $cep !== '' && (strlen($cep) < 8 || strlen($cep) > 20)) $error = 'Cep telefonu hatalı.';
      if (!$error && $wa !== '' && (strlen($wa) < 8 || strlen($wa) > 20)) $error = 'WhatsApp no hatalı.';
      if (!$error && $giris === '') $error = 'Giriş saati hatalı.';
      if (!$error && $cikis === '') $error = 'Çıkış saati hatalı.';

      if (!$error) {
        $stU = db()->prepare("
          UPDATE tesisler
             SET yetkili_isim = :a,
                 yetkili_soyisim = :b,
                 cep_telefonu = :c,
                 whatsapp_no = :d,
                 sezon = :e,
                 giris_saati = :f,
                 cikis_saati = :g
           WHERE id = :t
           LIMIT 1
        ");
        $stU->execute([
          ':a' => $yetkili_isim,
          ':b' => $yetkili_soyisim,
          ':c' => $cep,
          ':d' => $wa,
          ':e' => $sezon !== '' ? $sezon : null,
          ':f' => $giris,
          ':g' => $cikis,
          ':t' => $tesisId,
        ]);
        $okMsg = 'Tesis bilgileri kaydedildi.';
      }

    } elseif ($section === 'fatura') {
      $firma = clean_text((string)($_POST['firma_unvani'] ?? ''), 255);
      $f_adres = clean_text((string)($_POST['fatura_adresi'] ?? ''), 2000);
      $f_il = clean_text((string)($_POST['fatura_il'] ?? ''), 100);
      $f_ilce = clean_text((string)($_POST['fatura_ilce'] ?? ''), 100);
      $vd = clean_text((string)($_POST['vergi_dairesi'] ?? ''), 100);
      $vno = clean_text((string)($_POST['vergi_no'] ?? ''), 100);
      $fmail = clean_email_nullable((string)($_POST['fatura_mail'] ?? ''), 100);

      if (!$error && $firma === '') $error = 'Firma unvanı zorunlu.';
      if (!$error && $f_adres === '') $error = 'Fatura adresi zorunlu.';
      if (!$error && $f_il === '') $error = 'Fatura il zorunlu.';
      if (!$error && $f_ilce === '') $error = 'Fatura ilçe zorunlu.';
      if (!$error && $vd === '') $error = 'Vergi dairesi zorunlu.';
      if (!$error && $vno === '') $error = 'Vergi no zorunlu.';
      if (!$error && ((string)($_POST['fatura_mail'] ?? '') !== '') && $fmail === '') $error = 'Fatura mail hatalı.';

      if (!$error) {
        $stU = db()->prepare("
          UPDATE tesisler
             SET firma_unvani = :a,
                 fatura_adresi = :b,
                 fatura_il = :c,
                 fatura_ilce = :d,
                 vergi_dairesi = :e,
                 vergi_no = :f,
                 fatura_mail = :g
           WHERE id = :t
           LIMIT 1
        ");
        $stU->execute([
          ':a' => $firma,
          ':b' => $f_adres,
          ':c' => $f_il,
          ':d' => $f_ilce,
          ':e' => $vd,
          ':f' => $vno,
          ':g' => $fmail !== '' ? $fmail : null,
          ':t' => $tesisId,
        ]);
        $okMsg = 'Fatura bilgileri kaydedildi.';
      }
    }
  }

  $st = db()->prepare("SELECT * FROM tesisler WHERE id = :t LIMIT 1");
  $st->execute([':t' => $tesisId]);
  $row = $st->fetch() ?: [];
  foreach ($val as $k => $v) $val[$k] = (string)($row[$k] ?? '');
}

$csrf = csrf_token();

$selectedIl = $val['fatura_il'] !== '' ? $val['fatura_il'] : 'İstanbul';
$ilceList = $ilcelerMap[$selectedIl] ?? [];
$ilceSelected = $val['fatura_ilce'];

?>
<!doctype html>
<html lang="tr">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Hesap Yönetimi</title>

  <style>
    .account-grid{display:grid;grid-template-columns:1fr 1fr;gap:24px;align-items:start;}
    .account-card{background:#fff;border:1px solid rgba(11,22,53,.12);border-radius:14px;padding:18px;position:relative;}
    .account-legend{position:absolute;top:-12px;left:16px;background:#f6f7fb;border:1px solid rgba(11,22,53,.12);border-radius:8px;padding:6px 10px;font-weight:800;color:#0b1635;}
    .account-form-grid-2{display:grid;grid-template-columns:1fr 1fr;gap:16px;}
    .account-form-grid-1{display:grid;grid-template-columns:1fr;gap:16px;}
    .account-form-grid-3{display:grid;grid-template-columns:1fr 1fr 1fr;gap:16px;}
    .field-wrap{position:relative;}
    .field-tag{position:absolute;top:-9px;left:12px;background:#fff;border:1px solid #ff9800;border-radius:6px;padding:1px 8px;font-size:11px;font-weight:800;color:#ff9800;}
    .input-row{display:flex;gap:12px;align-items:center;}
    .btn-row{margin-top:16px;}
    .account-muted{font-size:12px;opacity:.8;}
    .account-two-btns{display:flex;gap:12px;align-items:center;flex-wrap:wrap;}
    @media (max-width: 1100px){.account-grid{grid-template-columns:1fr;}}
  </style>

  <script>
    window.BS = window.BS || {};
  </script>
</head>
<body class="panel-body">
<div class="panel-shell">
  <?php include __DIR__ . '/sidebar.php'; ?>
  <div class="panel-main">
    <header class="topbar">
      <div class="topbar-title">
        <div class="topbar-h1">Hesap Yönetimi</div>
        <div class="topbar-sub muted">Tesis ve fatura bilgilerini güncelle</div>
      </div>
      <div class="topbar-right">
        <a class="btn btn-ghost btn-sm" href="panel.php">← Panel</a>
      </div>
    </header>

    <main class="content">
      <?php if ($error): ?>
        <script>
          document.addEventListener('DOMContentLoaded', () => {
            const msg = <?= json_encode($error, JSON_UNESCAPED_UNICODE | JSON_HEX_TAG | JSON_HEX_AMP | JSON_HEX_APOS | JSON_HEX_QUOT) ?>;
            window.BS?.toast?.(msg, 'error', 12200);
          });
        </script>
      <?php endif; ?>

      <?php if ($okMsg): ?>
        <script>
          document.addEventListener('DOMContentLoaded', () => {
            const msg = <?= json_encode($okMsg, JSON_UNESCAPED_UNICODE | JSON_HEX_TAG | JSON_HEX_AMP | JSON_HEX_APOS | JSON_HEX_QUOT) ?>;
            window.BS?.toast?.(msg, 'success', 5200);
          });
        </script>
      <?php endif; ?>

      <div class="account-grid">

        <section class="account-card">
          <div class="account-legend">Tesis Bilgileri</div>

          <form method="post" novalidate>
            <input type="hidden" name="csrf_token" value="<?= e($csrf) ?>">
            <input type="hidden" name="section" value="tesis">

            <div class="account-form-grid-1" style="margin-top:10px;">
              <div class="field-wrap">
                <div class="field-tag">Tesis İsmi - Değiştirilemez</div>
                <input class="input" value="<?= e($val['tesis_ismi']) ?>" readonly disabled>
              </div>
            </div>

            <div class="account-form-grid-2" style="margin-top:16px;">
              <div class="field-wrap">
                <div class="field-tag">Yetkili İsim</div>
                <input class="input" name="yetkili_isim" value="<?= e($val['yetkili_isim']) ?>" required>
              </div>
              <div class="field-wrap">
                <div class="field-tag">Yetkili Soyisim</div>
                <input class="input" name="yetkili_soyisim" value="<?= e($val['yetkili_soyisim']) ?>" required>
              </div>
            </div>

            <div class="account-form-grid-1" style="margin-top:16px;">
              <div class="field-wrap">
                <div class="field-tag">E-Posta - Değiştirilemez</div>
                <input class="input" value="<?= e($val['email']) ?>" readonly disabled>
              </div>
            </div>

            <div class="account-form-grid-2" style="margin-top:16px;">
              <div class="field-wrap">
                <div class="field-tag">Cep Telefonu</div>
                <input class="input" name="cep_telefonu" value="<?= e($val['cep_telefonu']) ?>" inputmode="numeric" autocomplete="off">
              </div>
              <div class="field-wrap">
                <div class="field-tag">WhatsApp No</div>
                <input class="input" name="whatsapp_no" value="<?= e($val['whatsapp_no']) ?>" inputmode="numeric" autocomplete="off">
              </div>
            </div>

            <div class="account-form-grid-1" style="margin-top:16px;">
              <div class="field-wrap">
                <div class="field-tag">Tesis Adresi - Değiştirilemez</div>
                <textarea class="input" rows="3" readonly disabled><?= e($val['tesis_adresi']) ?></textarea>
              </div>
            </div>

            <div class="account-form-grid-2" style="margin-top:16px;">
              <div class="field-wrap">
                <div class="field-tag">Tesis İl - Değiştirilemez</div>
                <input class="input" value="<?= e($val['tesis_il']) ?>" readonly disabled>
              </div>
              <div class="field-wrap">
                <div class="field-tag">Tesis İlçe - Değiştirilemez</div>
                <input class="input" value="<?= e($val['tesis_ilce']) ?>" readonly disabled>
              </div>
            </div>

            <div class="account-form-grid-1" style="margin-top:16px;">
              <div class="field-wrap">
                <div class="field-tag">Sezon</div>
                <select class="input" name="sezon">
                  <option value="" <?= $val['sezon']===''?'selected':'' ?>>Seçiniz</option>
                  <option value="Yaz" <?= $val['sezon']==='Yaz'?'selected':'' ?>>Yaz</option>
                  <option value="Kış" <?= $val['sezon']==='Kış'?'selected':'' ?>>Kış</option>
                  <option value="Yaz/Kış" <?= $val['sezon']==='Yaz/Kış'?'selected':'' ?>>Yaz/Kış</option>
                </select>
              </div>
            </div>

            <div class="account-form-grid-2" style="margin-top:16px;">
              <div class="field-wrap">
                <div class="field-tag">Giriş Saati</div>
                <input class="input" name="giris_saati" value="<?= e($val['giris_saati']) ?>" placeholder="11:11" inputmode="numeric" autocomplete="off" required>
              </div>
              <div class="field-wrap">
                <div class="field-tag">Çıkış Saati</div>
                <input class="input" name="cikis_saati" value="<?= e($val['cikis_saati']) ?>" placeholder="22:22" inputmode="numeric" autocomplete="off" required>
              </div>
            </div>

            <div class="btn-row">
              <button class="btn btn-primary" type="submit">Bilgileri Kaydet</button>
            </div>
          </form>
        </section>

        <section class="account-card">
          <div class="account-legend">Fatura Bilgileri</div>

          <form method="post" novalidate>
            <input type="hidden" name="csrf_token" value="<?= e($csrf) ?>">
            <input type="hidden" name="section" value="fatura">

            <div class="account-form-grid-1" style="margin-top:10px;">
              <div class="field-wrap">
                <div class="field-tag">Firma Ünvanı</div>
                <input class="input" name="firma_unvani" value="<?= e($val['firma_unvani']) ?>" required>
              </div>
            </div>

            <div class="account-form-grid-1" style="margin-top:16px;">
              <div class="field-wrap">
                <div class="field-tag">Fatura Adresi</div>
                <textarea class="input" name="fatura_adresi" rows="3" required><?= e($val['fatura_adresi']) ?></textarea>
              </div>
            </div>

            <div class="account-form-grid-2" style="margin-top:16px;">
              <div class="field-wrap">
                <div class="field-tag">Fatura İl</div>
                <select class="input" name="fatura_il" id="fatura_il" required>
                  <option value="" disabled hidden <?= $val['fatura_il']===''?'selected':'' ?>>Seçiniz</option>
                  <?php foreach ($iller as $il): ?>
                    <option value="<?= e($il) ?>" <?= $val['fatura_il']===$il?'selected':'' ?>><?= e($il) ?></option>
                  <?php endforeach; ?>
                </select>
              </div>
              <div class="field-wrap">
                <div class="field-tag">Fatura İlçe</div>
                <select class="input" name="fatura_ilce" id="fatura_ilce" required>
                  <?php if ($ilceSelected !== '' && !in_array($ilceSelected, $ilceList, true)): ?>
                    <option value="<?= e($ilceSelected) ?>" selected><?= e($ilceSelected) ?></option>
                  <?php endif; ?>
                  <option value="" disabled hidden <?= $ilceSelected===''?'selected':'' ?>>Seçiniz</option>
                  <?php foreach ($ilceList as $ilce): ?>
                    <option value="<?= e($ilce) ?>" <?= $ilceSelected===$ilce?'selected':'' ?>><?= e($ilce) ?></option>
                  <?php endforeach; ?>
                </select>
              </div>
            </div>

            <div class="account-form-grid-2" style="margin-top:16px;">
              <div class="field-wrap">
                <div class="field-tag">Vergi Dairesi</div>
                <input class="input" name="vergi_dairesi" value="<?= e($val['vergi_dairesi']) ?>" required>
              </div>
              <div class="field-wrap">
                <div class="field-tag">Vergi No</div>
                <input class="input" name="vergi_no" value="<?= e($val['vergi_no']) ?>" required>
              </div>
            </div>

            <div class="account-form-grid-1" style="margin-top:16px;">
              <div class="field-wrap">
                <div class="field-tag">Fatura Mail Adresi</div>
                <input class="input" name="fatura_mail" value="<?= e($val['fatura_mail']) ?>" inputmode="email" autocomplete="off">
              </div>
            </div>

            <div class="account-form-grid-2" style="margin-top:16px;">
              <div class="field-wrap">
                <div class="field-tag">KEP Adresi - Değiştirilemez</div>
                <input class="input" value="<?= e($val['kep_adresi']) ?>" readonly disabled>
              </div>
              <div class="field-wrap">
                <div class="field-tag">MERSİS No - Değiştirilemez</div>
                <input class="input" value="<?= e($val['mersis_no']) ?>" readonly disabled>
              </div>
            </div>

            <div class="btn-row">
              <button class="btn btn-primary" type="submit">Bilgileri Kaydet</button>
            </div>
          </form>
        </section>

      </div>
    </main>
  </div>
</div>

<script>
  (function(){
    const ilceMap = <?= json_encode($ilcelerMap, JSON_UNESCAPED_UNICODE | JSON_HEX_TAG | JSON_HEX_AMP | JSON_HEX_APOS | JSON_HEX_QUOT) ?>;
    const ilSel = document.getElementById('fatura_il');
    const ilceSel = document.getElementById('fatura_ilce');
    if (!ilSel || !ilceSel) return;

    const rebuild = (il) => {
      const prev = String(ilceSel.value || '');
      const list = ilceMap[il] || [];
      const keep = (prev && !list.includes(prev)) ? prev : '';
      const opts = [];

      if (keep) opts.push({v: keep, t: keep, s: true});
      opts.push({v: '', t: 'Seçiniz', h: true, d: true, s: !keep});

      list.forEach((x) => opts.push({v: x, t: x, s: (x === prev)}));

      ilceSel.innerHTML = '';
      opts.forEach((o) => {
        const op = document.createElement('option');
        op.value = o.v;
        op.textContent = o.t;
        if (o.h) op.hidden = true;
        if (o.d) op.disabled = true;
        if (o.s) op.selected = true;
        ilceSel.appendChild(op);
      });
    };

    ilSel.addEventListener('change', () => rebuild(ilSel.value));
  })();
</script>

</body>
</html>
